/*
 * Decompiled with CFR 0.152.
 */
package cn.moerain.linuxssh.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\"\u0010\u000b\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\u0006\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\"\u0010\u000e\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u0006\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\nR\"\u0010\u0011\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\u0006\u001a\u0004\b\u0012\u0010\b\"\u0004\b\u0013\u0010\n\u00a8\u0006\u0015"}, d2={"Lcn/moerain/linuxssh/config/LinuxsshConfig;", "", "<init>", "()V", "", "deleteHostFingerprint", "Z", "getDeleteHostFingerprint", "()Z", "setDeleteHostFingerprint", "(Z)V", "preferKeyAuthentication", "getPreferKeyAuthentication", "setPreferKeyAuthentication", "enableKeyGeneration", "getEnableKeyGeneration", "setEnableKeyGeneration", "showPublicKeyPassword", "getShowPublicKeyPassword", "setShowPublicKeyPassword", "Companion", "linuxssh"})
public final class LinuxsshConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean deleteHostFingerprint;
    private boolean preferKeyAuthentication = true;
    private boolean enableKeyGeneration = true;
    private boolean showPublicKeyPassword;
    private static final File configFile = FabricLoader.getInstance().getConfigDir().resolve("linuxssh/config.json").toFile();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    @Nullable
    private static LinuxsshConfig instance;

    public final boolean getDeleteHostFingerprint() {
        return this.deleteHostFingerprint;
    }

    public final void setDeleteHostFingerprint(boolean bl) {
        this.deleteHostFingerprint = bl;
    }

    public final boolean getPreferKeyAuthentication() {
        return this.preferKeyAuthentication;
    }

    public final void setPreferKeyAuthentication(boolean bl) {
        this.preferKeyAuthentication = bl;
    }

    public final boolean getEnableKeyGeneration() {
        return this.enableKeyGeneration;
    }

    public final void setEnableKeyGeneration(boolean bl) {
        this.enableKeyGeneration = bl;
    }

    public final boolean getShowPublicKeyPassword() {
        return this.showPublicKeyPassword;
    }

    public final void setShowPublicKeyPassword(boolean bl) {
        this.showPublicKeyPassword = bl;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0006J\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\u0003R\u001c\u0010\f\u001a\n \u000b*\u0004\u0018\u00010\n0\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u001c\u0010\u000f\u001a\n \u000b*\u0004\u0018\u00010\u000e0\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcn/moerain/linuxssh/config/LinuxsshConfig$Companion;", "", "<init>", "()V", "Lcn/moerain/linuxssh/config/LinuxsshConfig;", "getInstance", "()Lcn/moerain/linuxssh/config/LinuxsshConfig;", "load", "", "save", "Ljava/io/File;", "kotlin.jvm.PlatformType", "configFile", "Ljava/io/File;", "Lcom/google/gson/Gson;", "gson", "Lcom/google/gson/Gson;", "instance", "Lcn/moerain/linuxssh/config/LinuxsshConfig;", "linuxssh"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LinuxsshConfig getInstance() {
            if (instance == null) {
                instance = this.load();
            }
            LinuxsshConfig linuxsshConfig = instance;
            Intrinsics.checkNotNull((Object)linuxsshConfig);
            return linuxsshConfig;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final LinuxsshConfig load() {
            if (configFile.exists()) {
                try {
                    Closeable closeable = new FileReader(configFile);
                    Throwable throwable = null;
                    try {
                        FileReader reader = (FileReader)closeable;
                        boolean bl = false;
                        LinuxsshConfig linuxsshConfig = (LinuxsshConfig)gson.fromJson((Reader)reader, LinuxsshConfig.class);
                        if (linuxsshConfig == null) {
                            linuxsshConfig = new LinuxsshConfig();
                        }
                        LinuxsshConfig linuxsshConfig2 = linuxsshConfig;
                        return linuxsshConfig2;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (Exception e) {
                    System.out.println((Object)("Failed to load LinuxSSH config: " + e.getMessage()));
                    e.printStackTrace();
                }
            }
            return new LinuxsshConfig();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void save() {
            try {
                if (!configFile.getParentFile().exists()) {
                    configFile.getParentFile().mkdirs();
                }
                Closeable closeable = new FileWriter(configFile);
                Throwable throwable = null;
                try {
                    FileWriter writer = (FileWriter)closeable;
                    boolean bl = false;
                    gson.toJson((Object)Companion.getInstance(), (Appendable)writer);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                System.out.println((Object)("Failed to save LinuxSSH config: " + e.getMessage()));
                e.printStackTrace();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

