/*
 * Decompiled with CFR 0.152.
 */
package cn.moerain.linuxssh.client.config;

import cn.moerain.linuxssh.client.config.LinuxsshConfigScreen;
import cn.moerain.linuxssh.config.LinuxsshConfig;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.KeyPair;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\u0007"}, d2={"Lcn/moerain/linuxssh/client/config/LinuxsshConfigScreen;", "", "<init>", "()V", "create", "Lnet/minecraft/client/gui/screens/Screen;", "parent", "linuxssh_client"})
public final class LinuxsshConfigScreen {
    @NotNull
    public static final LinuxsshConfigScreen INSTANCE = new LinuxsshConfigScreen();

    private LinuxsshConfigScreen() {
    }

    @NotNull
    public final Screen create(@Nullable Screen parent) {
        MutableComponent mutableComponent = Component.translatable((String)"linuxssh.config.title");
        return new Screen(parent, mutableComponent){
            private final LinuxsshConfig config;
            private Screen parentScreen;
            private String showMessage;
            {
                this.config = LinuxsshConfig.Companion.getInstance();
                this.parentScreen = $parent;
            }

            protected void init() {
                File file;
                super.init();
                this.clearWidgets();
                int y = 40;
                int x = this.width / 2 - 150;
                int buttonWidth = 300;
                int buttonHeight = 20;
                this.addRenderableWidget((GuiEventListener)CycleButton.onOffBuilder((boolean)this.config.getPreferKeyAuthentication()).create(x, y, buttonWidth, buttonHeight, (Component)Component.translatable((String)"linuxssh.config.option.prefer_key_authentication"), (arg_0, arg_1) -> create.1.init$lambda$0(this, arg_0, arg_1)));
                this.addRenderableWidget((GuiEventListener)CycleButton.onOffBuilder((boolean)this.config.getEnableKeyGeneration()).create(x, y += 24, buttonWidth, buttonHeight, (Component)Component.translatable((String)"linuxssh.config.option.enable_key_generation"), (arg_0, arg_1) -> create.1.init$lambda$1(this, arg_0, arg_1)));
                this.addRenderableWidget((GuiEventListener)CycleButton.onOffBuilder((boolean)this.config.getShowPublicKeyPassword()).create(x, y += 24, buttonWidth, buttonHeight, (Component)Component.translatable((String)"linuxssh.config.option.show_public_key_password"), (arg_0, arg_1) -> create.1.init$lambda$2(this, arg_0, arg_1)));
                this.addRenderableWidget((GuiEventListener)CycleButton.onOffBuilder((boolean)this.config.getDeleteHostFingerprint()).create(x, y += 24, buttonWidth, buttonHeight, (Component)Component.translatable((String)"linuxssh.config.option.delete_host_fingerprint"), (arg_0, arg_1) -> create.1.init$lambda$3(this, arg_0, arg_1)));
                y += 28;
                Minecraft minecraft = Minecraft.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)minecraft, (String)"getInstance(...)");
                Minecraft client = minecraft;
                Object object = client.player;
                if (object == null || (object = object.getUUID()) == null || (object = ((UUID)object).toString()) == null) {
                    object = "unknown";
                }
                Object playerUuid = object;
                File $this$init_u24lambda_u244 = file = new File("config/linuxssh/keys/" + (String)playerUuid);
                boolean bl = false;
                if (!$this$init_u24lambda_u244.exists()) {
                    $this$init_u24lambda_u244.mkdirs();
                }
                File playerKeyDir = file;
                File privateKeyFile = new File(playerKeyDir, "id_rsa");
                File publicKeyFile = new File(playerKeyDir, "id_rsa.pub");
                if (this.config.getEnableKeyGeneration()) {
                    this.addRenderableWidget((GuiEventListener)Button.builder((Component)((Component)Component.translatable((String)"linuxssh.config.option.generate_keys")), arg_0 -> create.1.init$lambda$5(privateKeyFile, publicKeyFile, this, arg_0)).bounds(x, y, buttonWidth, buttonHeight).build());
                    y += 24;
                }
                if (publicKeyFile.exists() && this.config.getShowPublicKeyPassword()) {
                    String string;
                    try {
                        string = FilesKt.readText$default((File)publicKeyFile, null, (int)1, null);
                    }
                    catch (Exception e) {
                        string = "";
                    }
                    String content = string;
                    this.addRenderableWidget((GuiEventListener)Button.builder((Component)((Component)Component.translatable((String)"linuxssh.config.option.copy_public_key")), arg_0 -> create.1.init$lambda$6(content, this, arg_0)).bounds(x, y, buttonWidth, buttonHeight).build());
                    y += 24;
                }
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)((Component)Component.translatable((String)"linuxssh.hostfingerprint.clear_all")), arg_0 -> create.1.init$lambda$7(this, arg_0)).bounds(x, y, buttonWidth, buttonHeight).build());
                y += 28;
                this.addRenderableWidget((GuiEventListener)Button.builder((Component)((Component)Component.translatable((String)"gui.done")), arg_0 -> create.1.init$lambda$8(this, arg_0)).bounds(this.width / 2 - 100, this.height - 28, 200, 20).build());
            }

            private final void refreshWidgets() {
                this.clearWidgets();
                this.init();
            }

            public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
                Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
                super.renderBackground(graphics, mouseX, mouseY, delta);
            }

            public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
                File publicKeyFile;
                Object playerUuid;
                Intrinsics.checkNotNullParameter((Object)graphics, (String)"graphics");
                super.render(graphics, mouseX, mouseY, delta);
                graphics.drawCenteredString(this.font, this.title, this.width / 2, 15, 0xFFFFFF);
                String string = this.showMessage;
                if (string != null) {
                    String it = string;
                    boolean bl = false;
                    graphics.drawCenteredString(this.font, (Component)Component.literal((String)it), this.width / 2, 28, 0xA0FFA0);
                }
                Minecraft minecraft = Minecraft.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)minecraft, (String)"getInstance(...)");
                Minecraft client = minecraft;
                Object object = client.player;
                if (object == null || (object = object.getUUID()) == null || (object = ((UUID)object).toString()) == null) {
                    object = playerUuid = "unknown";
                }
                if ((publicKeyFile = new File("config/linuxssh/keys/" + (String)playerUuid + "/id_rsa.pub")).exists() && LinuxsshConfig.Companion.getInstance().getShowPublicKeyPassword()) {
                    String string2;
                    try {
                        string2 = StringsKt.take((String)FilesKt.readText$default((File)publicKeyFile, null, (int)1, null), (int)80);
                    }
                    catch (Exception exception) {
                        string2 = "";
                    }
                    String preview = string2;
                    graphics.drawCenteredString(this.font, (Component)Component.literal((String)preview), this.width / 2, 120, 0xCCCCCC);
                }
            }

            public void removed() {
                LinuxsshConfig.Companion.save();
            }

            public void onClose() {
                block0: {
                    Minecraft minecraft = this.minecraft;
                    if (minecraft == null) break block0;
                    minecraft.setScreen(this.parentScreen);
                }
            }

            private final void showSaveToast() {
                Minecraft minecraft = Minecraft.getInstance();
                Intrinsics.checkNotNullExpressionValue((Object)minecraft, (String)"getInstance(...)");
                Minecraft client = minecraft;
                client.getToastManager().addToast((Toast)new SystemToast(SystemToast.SystemToastId.PERIODIC_NOTIFICATION, (Component)Component.translatable((String)"linuxssh.config.saved.title"), (Component)Component.translatable((String)"linuxssh.config.saved.message")));
            }

            private static final void init$lambda$0(create.1 this$0, CycleButton cycleButton, boolean value) {
                Intrinsics.checkNotNullParameter((Object)cycleButton, (String)"<unused var>");
                this$0.config.setPreferKeyAuthentication(value);
                LinuxsshConfig.Companion.save();
            }

            private static final void init$lambda$1(create.1 this$0, CycleButton cycleButton, boolean value) {
                Intrinsics.checkNotNullParameter((Object)cycleButton, (String)"<unused var>");
                this$0.config.setEnableKeyGeneration(value);
                LinuxsshConfig.Companion.save();
                this$0.refreshWidgets();
            }

            private static final void init$lambda$2(create.1 this$0, CycleButton cycleButton, boolean value) {
                Intrinsics.checkNotNullParameter((Object)cycleButton, (String)"<unused var>");
                this$0.config.setShowPublicKeyPassword(value);
                LinuxsshConfig.Companion.save();
                this$0.refreshWidgets();
            }

            private static final void init$lambda$3(create.1 this$0, CycleButton cycleButton, boolean value) {
                Intrinsics.checkNotNullParameter((Object)cycleButton, (String)"<unused var>");
                this$0.config.setDeleteHostFingerprint(value);
                LinuxsshConfig.Companion.save();
            }

            private static final void init$lambda$5(File $privateKeyFile, File $publicKeyFile, create.1 this$0, Button it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    KeyPair keyPair = KeyPair.genKeyPair((JSch)new JSch(), (int)2, (int)2048);
                    keyPair.writePrivateKey((OutputStream)new FileOutputStream($privateKeyFile));
                    keyPair.writePublicKey((OutputStream)new FileOutputStream($publicKeyFile), "");
                    keyPair.dispose();
                    this$0.showMessage = "Keys generated";
                    this$0.refreshWidgets();
                }
                catch (Exception e) {
                    this$0.showMessage = "Failed to generate keys: " + e.getMessage();
                    e.printStackTrace();
                }
            }

            private static final void init$lambda$6(String $content, create.1 this$0, Button it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    StringSelection selection = new StringSelection($content);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(selection, selection);
                    this$0.showMessage = "Public key copied";
                }
                catch (Exception e) {
                    this$0.showMessage = "Failed to copy: " + e.getMessage();
                }
            }

            private static final void init$lambda$7(create.1 this$0, Button it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    File knownHostsFile = new File("config/linuxssh/known_hosts");
                    if (knownHostsFile.exists()) {
                        FilesKt.writeText$default((File)knownHostsFile, (String)"", null, (int)2, null);
                    }
                    this$0.showMessage = "Known hosts cleared";
                }
                catch (Exception e) {
                    this$0.showMessage = "Failed to clear: " + e.getMessage();
                }
            }

            private static final void init$lambda$8(create.1 this$0, Button it) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    LinuxsshConfig.Companion.save();
                    this$0.showSaveToast();
                    Minecraft minecraft = this$0.minecraft;
                    if (minecraft == null) break block0;
                    minecraft.setScreen(this$0.parentScreen);
                }
            }
        };
    }
}

