/*
 * Decompiled with CFR 0.152.
 */
package cn.moerain.linuxssh;

import cn.moerain.linuxssh.Linuxssh;
import cn.moerain.linuxssh.config.LinuxsshConfig;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0011\u001a\u00020\u000bH\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0016\u0010\u0014\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u001e\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001b2\u0006\u0010\u001c\u001a\u00020\rH\u0002J\u0016\u0010\u001d\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001bH\u0002J\u0016\u0010\u001e\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001bH\u0002J\u0016\u0010\u001f\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001bH\u0002J\u0016\u0010 \u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001bH\u0002J\u0016\u0010!\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001bH\u0002J\u0016\u0010\"\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u001bH\u0002J\u0010\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\nH\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcn/moerain/linuxssh/Linuxssh;", "Lnet/fabricmc/api/ModInitializer;", "<init>", "()V", "activeSessions", "", "Ljava/util/UUID;", "Lcom/jcraft/jsch/Session;", "pendingPasswords", "Lkotlin/Function1;", "", "", "pendingFingerprints", "", "sshKeysDir", "Ljava/io/File;", "knownHostsFile", "onInitialize", "deleteHostFingerprint", "host", "registerSshCommand", "dispatcher", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "handleFingerprintConfirmation", "", "context", "Lcom/mojang/brigadier/context/CommandContext;", "confirmed", "handleDisconnect", "handlePasswordInput", "handleKeyImport", "handleKeyGenerate", "handleSshConnect", "handleSshCommand", "formatAnsiToMinecraft", "input", "linuxssh"})
@SourceDebugExtension(value={"SMAP\nLinuxssh.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Linuxssh.kt\ncn/moerain/linuxssh/Linuxssh\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,601:1\n14060#2,2:602\n1#3:604\n*S KotlinDebug\n*F\n+ 1 Linuxssh.kt\ncn/moerain/linuxssh/Linuxssh\n*L\n379#1:602,2\n*E\n"})
public final class Linuxssh
implements ModInitializer {
    @NotNull
    private final Map<UUID, Session> activeSessions = new LinkedHashMap();
    @NotNull
    private final Map<UUID, Function1<String, Unit>> pendingPasswords = new LinkedHashMap();
    @NotNull
    private final Map<UUID, Function1<Boolean, Unit>> pendingFingerprints = new LinkedHashMap();
    @NotNull
    private final File sshKeysDir = new File("config/linuxssh/keys");
    @NotNull
    private final File knownHostsFile = new File("config/linuxssh/known_hosts");

    public void onInitialize() {
        if (!this.sshKeysDir.exists()) {
            this.sshKeysDir.mkdirs();
        }
        if (!this.knownHostsFile.getParentFile().exists()) {
            this.knownHostsFile.getParentFile().mkdirs();
        }
        if (!this.knownHostsFile.exists()) {
            this.knownHostsFile.createNewFile();
        }
        LinuxsshConfig.Companion.getInstance();
        CommandRegistrationCallback.EVENT.register((arg_0, arg_1, arg_2) -> Linuxssh.onInitialize$lambda$0(this, arg_0, arg_1, arg_2));
    }

    private final boolean deleteHostFingerprint(String host) {
        try {
            JSch jsch = new JSch();
            jsch.setKnownHosts(this.knownHostsFile.getAbsolutePath());
            HostKeyRepository hostKeyRepository = jsch.getHostKeyRepository();
            HostKey[] hostKeys = hostKeyRepository.getHostKey();
            boolean found = false;
            Intrinsics.checkNotNull((Object)hostKeys);
            for (HostKey hostKey : hostKeys) {
                if (!Intrinsics.areEqual((Object)hostKey.getHost(), (Object)host)) continue;
                hostKeyRepository.remove(host, hostKey.getType());
                found = true;
                break;
            }
            return found;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private final void registerSshCommand(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ssh").then(Commands.literal((String)"disconnect").executes(arg_0 -> Linuxssh.registerSshCommand$lambda$0(this, arg_0)))).then(Commands.literal((String)"password").then(Commands.argument((String)"password", (ArgumentType)((ArgumentType)StringArgumentType.greedyString())).executes(arg_0 -> Linuxssh.registerSshCommand$lambda$1(this, arg_0))))).then(((LiteralArgumentBuilder)Commands.literal((String)"confirm").then(Commands.literal((String)"yes").executes(arg_0 -> Linuxssh.registerSshCommand$lambda$2(this, arg_0)))).then(Commands.literal((String)"no").executes(arg_0 -> Linuxssh.registerSshCommand$lambda$3(this, arg_0))))).then(((LiteralArgumentBuilder)Commands.literal((String)"key").then(Commands.literal((String)"import").then(Commands.argument((String)"keypath", (ArgumentType)((ArgumentType)StringArgumentType.greedyString())).executes(arg_0 -> Linuxssh.registerSshCommand$lambda$4(this, arg_0))))).then(Commands.literal((String)"generate").executes(arg_0 -> Linuxssh.registerSshCommand$lambda$5(this, arg_0))))).then(Commands.literal((String)"connect").then(Commands.argument((String)"connection", (ArgumentType)((ArgumentType)StringArgumentType.greedyString())).executes(arg_0 -> Linuxssh.registerSshCommand$lambda$6(this, arg_0))))).then(Commands.literal((String)"command").then(Commands.argument((String)"command", (ArgumentType)((ArgumentType)StringArgumentType.greedyString())).executes(arg_0 -> Linuxssh.registerSshCommand$lambda$7(this, arg_0)))));
    }

    private final int handleFingerprintConfirmation(CommandContext<CommandSourceStack> context, boolean confirmed) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer serverPlayer = source.getPlayer();
        if (serverPlayer == null) {
            return 0;
        }
        ServerPlayer player = serverPlayer;
        Function1<Boolean, Unit> fingerprintCallback = this.pendingFingerprints.get(player.getUUID());
        if (fingerprintCallback != null) {
            fingerprintCallback.invoke((Object)confirmed);
            this.pendingFingerprints.remove(player.getUUID());
            if (confirmed) {
                source.sendSuccess(Linuxssh::handleFingerprintConfirmation$lambda$0, false);
            } else {
                source.sendSuccess(Linuxssh::handleFingerprintConfirmation$lambda$1, false);
            }
        } else {
            source.sendSuccess(Linuxssh::handleFingerprintConfirmation$lambda$2, false);
        }
        return 1;
    }

    private final int handleDisconnect(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer serverPlayer = source.getPlayer();
        if (serverPlayer == null) {
            return 0;
        }
        ServerPlayer player = serverPlayer;
        Session session = this.activeSessions.get(player.getUUID());
        if (session != null && session.isConnected()) {
            session.disconnect();
            this.activeSessions.remove(player.getUUID());
            source.sendSuccess(Linuxssh::handleDisconnect$lambda$0, false);
        } else {
            source.sendSuccess(Linuxssh::handleDisconnect$lambda$1, false);
        }
        return 1;
    }

    private final int handlePasswordInput(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer serverPlayer = source.getPlayer();
        if (serverPlayer == null) {
            return 0;
        }
        ServerPlayer player = serverPlayer;
        String password = StringArgumentType.getString(context, (String)"password");
        Function1<String, Unit> passwordCallback = this.pendingPasswords.get(player.getUUID());
        if (passwordCallback != null) {
            Intrinsics.checkNotNull((Object)password);
            passwordCallback.invoke((Object)password);
            this.pendingPasswords.remove(player.getUUID());
            source.sendSuccess(Linuxssh::handlePasswordInput$lambda$0, false);
        } else {
            source.sendSuccess(Linuxssh::handlePasswordInput$lambda$1, false);
        }
        return 1;
    }

    private final int handleKeyImport(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer serverPlayer = source.getPlayer();
        if (serverPlayer == null) {
            return 0;
        }
        ServerPlayer player = serverPlayer;
        String keyPath = StringArgumentType.getString(context, (String)"keypath");
        CompletableFuture.runAsync(() -> Linuxssh.handleKeyImport$lambda$0(keyPath, source, this, player));
        return 1;
    }

    private final int handleKeyGenerate(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer serverPlayer = source.getPlayer();
        if (serverPlayer == null) {
            return 0;
        }
        ServerPlayer player = serverPlayer;
        LinuxsshConfig config = LinuxsshConfig.Companion.getInstance();
        if (!config.getEnableKeyGeneration()) {
            source.sendSuccess(Linuxssh::handleKeyGenerate$lambda$0, false);
            return 1;
        }
        CompletableFuture.runAsync(() -> Linuxssh.handleKeyGenerate$lambda$1(this, player, source));
        return 1;
    }

    private final int handleSshConnect(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayer();
        String connectionString = StringArgumentType.getString(context, (String)"connection");
        CompletableFuture.runAsync(() -> Linuxssh.handleSshConnect$lambda$0(connectionString, source, player, this));
        return 1;
    }

    private final int handleSshCommand(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.getPlayer();
        String command = StringArgumentType.getString(context, (String)"command");
        CompletableFuture.runAsync(() -> Linuxssh.handleSshCommand$lambda$0(player, source, command, this));
        return 1;
    }

    private final String formatAnsiToMinecraft(String input) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"0;30", (Object)"\u00a70"), TuplesKt.to((Object)"0;34", (Object)"\u00a71"), TuplesKt.to((Object)"0;32", (Object)"\u00a72"), TuplesKt.to((Object)"0;36", (Object)"\u00a73"), TuplesKt.to((Object)"0;31", (Object)"\u00a74"), TuplesKt.to((Object)"0;35", (Object)"\u00a75"), TuplesKt.to((Object)"0;33", (Object)"\u00a76"), TuplesKt.to((Object)"0;37", (Object)"\u00a77"), TuplesKt.to((Object)"1;30", (Object)"\u00a78"), TuplesKt.to((Object)"1;34", (Object)"\u00a79"), TuplesKt.to((Object)"1;32", (Object)"\u00a7a"), TuplesKt.to((Object)"1;36", (Object)"\u00a7b"), TuplesKt.to((Object)"1;31", (Object)"\u00a7c"), TuplesKt.to((Object)"1;35", (Object)"\u00a7d"), TuplesKt.to((Object)"1;33", (Object)"\u00a7e"), TuplesKt.to((Object)"1;37", (Object)"\u00a7f"), TuplesKt.to((Object)"30", (Object)"\u00a70"), TuplesKt.to((Object)"34", (Object)"\u00a71"), TuplesKt.to((Object)"32", (Object)"\u00a72"), TuplesKt.to((Object)"36", (Object)"\u00a73"), TuplesKt.to((Object)"31", (Object)"\u00a74"), TuplesKt.to((Object)"35", (Object)"\u00a75"), TuplesKt.to((Object)"33", (Object)"\u00a76"), TuplesKt.to((Object)"37", (Object)"\u00a77"), TuplesKt.to((Object)"0", (Object)"\u00a7r"), TuplesKt.to((Object)"1", (Object)"\u00a7l"), TuplesKt.to((Object)"4", (Object)"\u00a7n")};
        Map colorMap = MapsKt.mapOf((Pair[])pairArray);
        Pattern pattern = Pattern.compile("\u001b\\[([0-9;]+)m");
        Matcher matcher = pattern.matcher(input);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String code = matcher.group(1);
            String string = (String)colorMap.get(code);
            if (string == null) {
                string = "";
            }
            String replacement = string;
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final void onInitialize$lambda$0(Linuxssh this$0, CommandDispatcher dispatcher, CommandBuildContext commandBuildContext, Commands.CommandSelection commandSelection) {
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)commandBuildContext, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)commandSelection, (String)"<unused var>");
        this$0.registerSshCommand((CommandDispatcher<CommandSourceStack>)dispatcher);
    }

    private static final int registerSshCommand$lambda$0(Linuxssh this$0, CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return this$0.handleDisconnect((CommandContext<CommandSourceStack>)context);
    }

    private static final int registerSshCommand$lambda$1(Linuxssh this$0, CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return this$0.handlePasswordInput((CommandContext<CommandSourceStack>)context);
    }

    private static final int registerSshCommand$lambda$2(Linuxssh this$0, CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return this$0.handleFingerprintConfirmation((CommandContext<CommandSourceStack>)context, true);
    }

    private static final int registerSshCommand$lambda$3(Linuxssh this$0, CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return this$0.handleFingerprintConfirmation((CommandContext<CommandSourceStack>)context, false);
    }

    private static final int registerSshCommand$lambda$4(Linuxssh this$0, CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return this$0.handleKeyImport((CommandContext<CommandSourceStack>)context);
    }

    private static final int registerSshCommand$lambda$5(Linuxssh this$0, CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return this$0.handleKeyGenerate((CommandContext<CommandSourceStack>)context);
    }

    private static final int registerSshCommand$lambda$6(Linuxssh this$0, CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return this$0.handleSshConnect((CommandContext<CommandSourceStack>)context);
    }

    private static final int registerSshCommand$lambda$7(Linuxssh this$0, CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        return this$0.handleSshCommand((CommandContext<CommandSourceStack>)context);
    }

    private static final Component handleFingerprintConfirmation$lambda$0() {
        return (Component)Component.translatable((String)"linuxssh.command.fingerprint_accepted");
    }

    private static final Component handleFingerprintConfirmation$lambda$1() {
        return (Component)Component.translatable((String)"linuxssh.command.fingerprint_rejected");
    }

    private static final Component handleFingerprintConfirmation$lambda$2() {
        return (Component)Component.translatable((String)"linuxssh.command.not_connected");
    }

    private static final Component handleDisconnect$lambda$0() {
        return (Component)Component.translatable((String)"linuxssh.command.disconnect");
    }

    private static final Component handleDisconnect$lambda$1() {
        return (Component)Component.translatable((String)"linuxssh.command.not_connected");
    }

    private static final Component handlePasswordInput$lambda$0() {
        return (Component)Component.translatable((String)"linuxssh.command.password_prompt");
    }

    private static final Component handlePasswordInput$lambda$1() {
        return (Component)Component.translatable((String)"linuxssh.command.not_connected");
    }

    private static final Component handleKeyImport$lambda$0$0(String $keyPath) {
        Object[] objectArray = new Object[]{$keyPath};
        return (Component)Component.translatable((String)"linuxssh.command.key_import_error", (Object[])objectArray);
    }

    private static final Component handleKeyImport$lambda$0$2(String $errorMsg) {
        Object[] objectArray = new Object[]{$errorMsg};
        return (Component)Component.translatable((String)"linuxssh.command.key_import_error", (Object[])objectArray);
    }

    private static final Component handleKeyImport$lambda$0$3(File $keyFile) {
        Object[] objectArray = new Object[]{$keyFile.getName()};
        return (Component)Component.translatable((String)"linuxssh.command.key_imported", (Object[])objectArray);
    }

    private static final Component handleKeyImport$lambda$0$4() {
        return (Component)Component.translatable((String)"linuxssh.key.imported_content_header");
    }

    private static final Component handleKeyImport$lambda$0$5(String $keyContent) {
        return (Component)Component.literal((String)("\u00a7a" + $keyContent));
    }

    private static final Component handleKeyImport$lambda$0$6() {
        return (Component)Component.translatable((String)"linuxssh.key.imported_content_footer");
    }

    private static final Component handleKeyImport$lambda$0$7() {
        return (Component)Component.translatable((String)"linuxssh.key.imported_public_content_header");
    }

    private static final Component handleKeyImport$lambda$0$8(String $publicKeyContent) {
        return (Component)Component.literal((String)("\u00a7a" + $publicKeyContent));
    }

    private static final Component handleKeyImport$lambda$0$9() {
        return (Component)Component.translatable((String)"linuxssh.key.imported_public_content_footer");
    }

    private static final Component handleKeyImport$lambda$0$10(File $publicKeyFile) {
        Object[] objectArray = new Object[]{$publicKeyFile.getName()};
        return (Component)Component.translatable((String)"linuxssh.command.key_imported", (Object[])objectArray);
    }

    private static final Component handleKeyImport$lambda$0$11(Exception $e) {
        Object[] objectArray = new Object[1];
        String string = $e.getMessage();
        if (string == null) {
            string = "";
        }
        objectArray[0] = string;
        return (Component)Component.translatable((String)"linuxssh.command.key_import_error", (Object[])objectArray);
    }

    private static final void handleKeyImport$lambda$0(String $keyPath, CommandSourceStack $source, Linuxssh this$0, ServerPlayer $player) {
        try {
            File publicKeyFile;
            File keyFile = new File($keyPath);
            if (!keyFile.exists() || !keyFile.isFile()) {
                $source.sendSuccess(() -> Linuxssh.handleKeyImport$lambda$0$0($keyPath), false);
                return;
            }
            File playerKeyDir = new File(this$0.sshKeysDir, $player.getUUID().toString());
            if (!playerKeyDir.exists()) {
                playerKeyDir.mkdirs();
            }
            JSch jsch = new JSch();
            try {
                jsch.addIdentity(keyFile.getAbsolutePath());
            }
            catch (JSchException e) {
                String string;
                String string2 = e.getMessage();
                if (string2 != null) {
                    String it = string2;
                    boolean bl = false;
                    string = StringsKt.contains$default((CharSequence)it, (CharSequence)"[B@", (boolean)false, (int)2, null) ? "invalid privatekey format" : it;
                } else {
                    string = "unknown error";
                }
                String errorMsg = string;
                $source.sendSuccess(() -> Linuxssh.handleKeyImport$lambda$0$2(errorMsg), false);
                return;
            }
            File targetFile = new File(playerKeyDir, keyFile.getName());
            FilesKt.copyTo$default((File)keyFile, (File)targetFile, (boolean)true, (int)0, (int)4, null);
            $source.sendSuccess(() -> Linuxssh.handleKeyImport$lambda$0$3(keyFile), false);
            String keyContent = FilesKt.readText$default((File)keyFile, null, (int)1, null);
            $source.sendSuccess(Linuxssh::handleKeyImport$lambda$0$4, false);
            $source.sendSuccess(() -> Linuxssh.handleKeyImport$lambda$0$5(keyContent), false);
            $source.sendSuccess(Linuxssh::handleKeyImport$lambda$0$6, false);
            String string = keyFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.endsWith$default((String)string, (String)".pub", (boolean)false, (int)2, null) && (publicKeyFile = new File($keyPath + ".pub")).exists() && publicKeyFile.isFile()) {
                File targetPublicFile = new File(playerKeyDir, publicKeyFile.getName());
                FilesKt.copyTo$default((File)publicKeyFile, (File)targetPublicFile, (boolean)true, (int)0, (int)4, null);
                String publicKeyContent = FilesKt.readText$default((File)publicKeyFile, null, (int)1, null);
                $source.sendSuccess(Linuxssh::handleKeyImport$lambda$0$7, false);
                $source.sendSuccess(() -> Linuxssh.handleKeyImport$lambda$0$8(publicKeyContent), false);
                $source.sendSuccess(Linuxssh::handleKeyImport$lambda$0$9, false);
                $source.sendSuccess(() -> Linuxssh.handleKeyImport$lambda$0$10(publicKeyFile), false);
            }
        }
        catch (Exception e) {
            $source.sendSuccess(() -> Linuxssh.handleKeyImport$lambda$0$11(e), false);
            e.printStackTrace();
        }
    }

    private static final Component handleKeyGenerate$lambda$1$0() {
        return (Component)Component.translatable((String)"linuxssh.command.key_generated");
    }

    private static final Component handleKeyGenerate$lambda$1$1() {
        return (Component)Component.translatable((String)"linuxssh.key.generated_private_header");
    }

    private static final Component handleKeyGenerate$lambda$1$2(String $privateKeyContent) {
        return (Component)Component.literal((String)("\u00a7a" + $privateKeyContent));
    }

    private static final Component handleKeyGenerate$lambda$1$3() {
        return (Component)Component.translatable((String)"linuxssh.key.generated_private_footer");
    }

    private static final Component handleKeyGenerate$lambda$1$4() {
        return (Component)Component.translatable((String)"linuxssh.key.generated_public_header");
    }

    private static final Component handleKeyGenerate$lambda$1$5(String $publicKeyContent) {
        return (Component)Component.literal((String)("\u00a7a" + $publicKeyContent));
    }

    private static final Component handleKeyGenerate$lambda$1$6() {
        return (Component)Component.translatable((String)"linuxssh.key.generated_public_footer");
    }

    private static final Component handleKeyGenerate$lambda$1$7() {
        return (Component)Component.translatable((String)"linuxssh.command.key_usage_info");
    }

    private static final Component handleKeyGenerate$lambda$1$8(Exception $e) {
        Object[] objectArray = new Object[1];
        String string = $e.getMessage();
        if (string == null) {
            string = "";
        }
        objectArray[0] = string;
        return (Component)Component.translatable((String)"linuxssh.command.key_generation_error", (Object[])objectArray);
    }

    private static final Component handleKeyGenerate$lambda$0() {
        return (Component)Component.translatable((String)"linuxssh.command.key_generation_disabled");
    }

    private static final void handleKeyGenerate$lambda$1(Linuxssh this$0, ServerPlayer $player, CommandSourceStack $source) {
        try {
            File playerKeyDir = new File(this$0.sshKeysDir, $player.getUUID().toString());
            if (!playerKeyDir.exists()) {
                playerKeyDir.mkdirs();
            }
            File privateKeyFile = new File(playerKeyDir, "id_rsa");
            File publicKeyFile = new File(playerKeyDir, "id_rsa.pub");
            KeyPair keyPair = KeyPair.genKeyPair((JSch)new JSch(), (int)2, (int)2048);
            keyPair.writePrivateKey((OutputStream)new FileOutputStream(privateKeyFile), new byte[0]);
            keyPair.writePublicKey((OutputStream)new FileOutputStream(publicKeyFile), "");
            keyPair.dispose();
            $source.sendSuccess(Linuxssh::handleKeyGenerate$lambda$1$0, false);
            String privateKeyContent = FilesKt.readText$default((File)privateKeyFile, null, (int)1, null);
            $source.sendSuccess(Linuxssh::handleKeyGenerate$lambda$1$1, false);
            $source.sendSuccess(() -> Linuxssh.handleKeyGenerate$lambda$1$2(privateKeyContent), false);
            $source.sendSuccess(Linuxssh::handleKeyGenerate$lambda$1$3, false);
            String publicKeyContent = FilesKt.readText$default((File)publicKeyFile, null, (int)1, null);
            $source.sendSuccess(Linuxssh::handleKeyGenerate$lambda$1$4, false);
            $source.sendSuccess(() -> Linuxssh.handleKeyGenerate$lambda$1$5(publicKeyContent), false);
            $source.sendSuccess(Linuxssh::handleKeyGenerate$lambda$1$6, false);
            $source.sendSuccess(Linuxssh::handleKeyGenerate$lambda$1$7, false);
        }
        catch (Exception e) {
            $source.sendSuccess(() -> Linuxssh.handleKeyGenerate$lambda$1$8(e), false);
            e.printStackTrace();
        }
    }

    private static final Component handleSshConnect$lambda$0$2$0$0(File $keyFile) {
        Object[] objectArray = new Object[]{$keyFile.getName()};
        return (Component)Component.translatable((String)"linuxssh.command.key_imported", (Object[])objectArray);
    }

    private static final Component handleSshConnect$lambda$0$2$0$2(String $errorMsg) {
        Object[] objectArray = new Object[]{$errorMsg};
        return (Component)Component.translatable((String)"linuxssh.command.key_import_error", (Object[])objectArray);
    }

    private static final Component handleSshConnect$lambda$0$0() {
        return (Component)Component.translatable((String)"linuxssh.command.invalid_format");
    }

    private static final Component handleSshConnect$lambda$0$3(String $host) {
        Object[] objectArray = new Object[]{$host};
        return (Component)Component.translatable((String)"linuxssh.command.fingerprint_deleted", (Object[])objectArray);
    }

    private static final Component handleSshConnect$lambda$0$4(String $username, String $host) {
        Object[] objectArray = new Object[]{$username + '@' + $host};
        return (Component)Component.translatable((String)"linuxssh.command.connect", (Object[])objectArray);
    }

    private static final Component handleSshConnect$lambda$0$5(String $host) {
        Object[] objectArray = new Object[]{$host};
        return (Component)Component.translatable((String)"linuxssh.command.connected", (Object[])objectArray);
    }

    private static final Component handleSshConnect$lambda$0$6() {
        return (Component)Component.translatable((String)"linuxssh.command.key_auth_failed");
    }

    private static final Unit handleSshConnect$lambda$0$7(CompletableFuture $passwordPromise, String password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        $passwordPromise.complete(password);
        return Unit.INSTANCE;
    }

    private static final Component handleSshConnect$lambda$0$8() {
        return (Component)Component.translatable((String)"linuxssh.command.password_prompt");
    }

    private static final Component handleSshConnect$lambda$0$9(String $host) {
        Object[] objectArray = new Object[]{$host};
        return (Component)Component.translatable((String)"linuxssh.command.connected", (Object[])objectArray);
    }

    private static final Component handleSshConnect$lambda$0$10(Exception $e) {
        Object[] objectArray = new Object[1];
        String string = $e.getMessage();
        if (string == null) {
            string = "";
        }
        objectArray[0] = string;
        return (Component)Component.translatable((String)"linuxssh.command.connection_failed", (Object[])objectArray);
    }

    private static final Component handleSshConnect$lambda$0$12() {
        return (Component)Component.translatable((String)"linuxssh.command.invalid_format");
    }

    private static final Component handleSshConnect$lambda$0$13(Exception $e) {
        Object[] objectArray = new Object[1];
        String string = $e.getMessage();
        if (string == null) {
            string = "";
        }
        objectArray[0] = string;
        return (Component)Component.translatable((String)"linuxssh.command.error", (Object[])objectArray);
    }

    private static final void handleSshConnect$lambda$0(String $connectionString, CommandSourceStack $source, ServerPlayer $player, Linuxssh this$0) {
        block22: {
            try {
                block23: {
                    JSch jsch;
                    String host;
                    String username;
                    block24: {
                        Intrinsics.checkNotNull((Object)$connectionString);
                        if (!StringsKt.contains$default((CharSequence)$connectionString, (CharSequence)"@", (boolean)false, (int)2, null)) break block23;
                        String[] stringArray = new String[]{"@"};
                        List parts = StringsKt.split$default((CharSequence)$connectionString, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                        if (parts.size() != 2) {
                            $source.sendSuccess(Linuxssh::handleSshConnect$lambda$0$0, false);
                            return;
                        }
                        username = (String)parts.get(0);
                        host = (String)parts.get(1);
                        ServerPlayer serverPlayer = $player;
                        if (serverPlayer != null) {
                            ServerPlayer it = serverPlayer;
                            boolean bl = false;
                            Session session = this$0.activeSessions.get(it.getUUID());
                            if (session != null) {
                                session.disconnect();
                            }
                        }
                        jsch = new JSch();
                        jsch.setKnownHosts(this$0.knownHostsFile.getAbsolutePath());
                        ServerPlayer serverPlayer2 = $player;
                        if (serverPlayer2 == null) break block24;
                        ServerPlayer it = serverPlayer2;
                        boolean bl = false;
                        File playerKeyDir = new File(this$0.sshKeysDir, it.getUUID().toString());
                        if (!playerKeyDir.exists() || !playerKeyDir.isDirectory()) break block24;
                        File[] fileArray = playerKeyDir.listFiles();
                        if (fileArray == null) break block24;
                        File[] $this$forEach$iv = fileArray;
                        boolean $i$f$forEach = false;
                        int n = $this$forEach$iv.length;
                        for (int i = 0; i < n; ++i) {
                            File element$iv;
                            File keyFile = element$iv = $this$forEach$iv[i];
                            boolean bl2 = false;
                            if (!keyFile.isFile()) continue;
                            try {
                                jsch.addIdentity(keyFile.getAbsolutePath());
                                $source.sendSuccess(() -> Linuxssh.handleSshConnect$lambda$0$2$0$0(keyFile), false);
                                continue;
                            }
                            catch (JSchException e) {
                                String string;
                                block26: {
                                    block25: {
                                        string = e.getMessage();
                                        if (string == null) break block25;
                                        String it2 = string;
                                        boolean bl3 = false;
                                        String string2 = StringsKt.contains$default((CharSequence)it2, (CharSequence)"[B@", (boolean)false, (int)2, null) ? "invalid privatekey format" : it2;
                                        string = string2;
                                        if (string2 != null) break block26;
                                    }
                                    string = "unknown error";
                                }
                                String errorMsg = string;
                                $source.sendSuccess(() -> Linuxssh.handleSshConnect$lambda$0$2$0$2(errorMsg), false);
                            }
                        }
                    }
                    LinuxsshConfig config = LinuxsshConfig.Companion.getInstance();
                    if (config.getDeleteHostFingerprint() && this$0.deleteHostFingerprint(host)) {
                        $source.sendSuccess(() -> Linuxssh.handleSshConnect$lambda$0$3(host), false);
                    }
                    Session session = jsch.getSession(username, host, 22);
                    session.setConfig("StrictHostKeyChecking", "ask");
                    if ($player != null) {
                        session.setUserInfo(new UserInfo(this$0, $player, $source){
                            final /* synthetic */ Linuxssh this$0;
                            final /* synthetic */ ServerPlayer $player;
                            final /* synthetic */ CommandSourceStack $source;
                            {
                                this.this$0 = $receiver;
                                this.$player = $player;
                                this.$source = $source;
                            }

                            public String getPassword() {
                                return null;
                            }

                            public boolean promptYesNo(String message) {
                                boolean bl;
                                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                                CompletableFuture<T> fingerprintPromise = new CompletableFuture<T>();
                                Linuxssh.access$getPendingFingerprints$p(this.this$0).put(this.$player.getUUID(), arg_0 -> handleSshConnect.1.5.promptYesNo$lambda$0(fingerprintPromise, arg_0));
                                String formattedMessage = StringsKt.replace$default((String)message, (String)"\n", (String)" ", (boolean)false, (int)4, null);
                                this.$source.sendSuccess(() -> handleSshConnect.1.5.promptYesNo$lambda$1(formattedMessage), false);
                                this.$source.sendSuccess(handleSshConnect.1.5::promptYesNo$lambda$2, false);
                                try {
                                    T t = fingerprintPromise.get();
                                    Intrinsics.checkNotNull(t);
                                    bl = (Boolean)t;
                                }
                                catch (Exception e) {
                                    this.$source.sendSuccess(handleSshConnect.1.5::promptYesNo$lambda$3, false);
                                    Linuxssh.access$getPendingFingerprints$p(this.this$0).remove(this.$player.getUUID());
                                    bl = false;
                                }
                                return bl;
                            }

                            public boolean promptPassword(String message) {
                                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                                return true;
                            }

                            public boolean promptPassphrase(String message) {
                                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                                return false;
                            }

                            public String getPassphrase() {
                                return null;
                            }

                            public void showMessage(String message) {
                                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                                this.$source.sendSuccess(handleSshConnect.1.5::showMessage$lambda$4, false);
                            }

                            private static final Unit promptYesNo$lambda$0(CompletableFuture $fingerprintPromise, boolean confirmed) {
                                $fingerprintPromise.complete(confirmed);
                                return Unit.INSTANCE;
                            }

                            private static final Component promptYesNo$lambda$1(String $formattedMessage) {
                                return (Component)Component.literal((String)("\u00a7e" + $formattedMessage));
                            }

                            private static final Component promptYesNo$lambda$2() {
                                return (Component)Component.translatable((String)"linuxssh.command.fingerprint_prompt");
                            }

                            private static final Component promptYesNo$lambda$3() {
                                return (Component)Component.translatable((String)"linuxssh.command.fingerprint_rejected");
                            }

                            private static final Component showMessage$lambda$4() {
                                return (Component)Component.translatable((String)"linuxssh.command.fingerprint_prompt");
                            }
                        });
                    }
                    $source.sendSuccess(() -> Linuxssh.handleSshConnect$lambda$0$4(username, host), false);
                    boolean authSuccess = false;
                    if (config.getPreferKeyAuthentication()) {
                        try {
                            session.connect(5000);
                            authSuccess = true;
                            $source.sendSuccess(() -> Linuxssh.handleSshConnect$lambda$0$5(host), false);
                        }
                        catch (Exception e) {
                            $source.sendSuccess(Linuxssh::handleSshConnect$lambda$0$6, false);
                        }
                    }
                    if (!authSuccess && $player != null) {
                        CompletableFuture passwordPromise = new CompletableFuture();
                        this$0.pendingPasswords.put($player.getUUID(), (Function1<String, Unit>)((Function1)arg_0 -> Linuxssh.handleSshConnect$lambda$0$7(passwordPromise, arg_0)));
                        $source.sendSuccess(Linuxssh::handleSshConnect$lambda$0$8, false);
                        try {
                            String password = (String)passwordPromise.get();
                            session.setPassword(password);
                            session.connect(30000);
                            authSuccess = true;
                            $source.sendSuccess(() -> Linuxssh.handleSshConnect$lambda$0$9(host), false);
                        }
                        catch (Exception e) {
                            $source.sendSuccess(() -> Linuxssh.handleSshConnect$lambda$0$10(e), false);
                            this$0.pendingPasswords.remove($player.getUUID());
                            return;
                        }
                    }
                    ServerPlayer serverPlayer = $player;
                    if (serverPlayer != null) {
                        ServerPlayer it = serverPlayer;
                        boolean bl = false;
                        this$0.activeSessions.put(it.getUUID(), session);
                    }
                    break block22;
                }
                $source.sendSuccess(Linuxssh::handleSshConnect$lambda$0$12, false);
            }
            catch (Exception e) {
                $source.sendSuccess(() -> Linuxssh.handleSshConnect$lambda$0$13(e), false);
                e.printStackTrace();
            }
        }
    }

    private static final Component handleSshCommand$lambda$0$1() {
        return (Component)Component.translatable((String)"linuxssh.command.not_connected");
    }

    private static final Component handleSshCommand$lambda$0$3(String $formattedLine) {
        return (Component)Component.literal((String)$formattedLine);
    }

    private static final Component handleSshCommand$lambda$0$4(Exception $e) {
        Object[] objectArray = new Object[1];
        String string = $e.getMessage();
        if (string == null) {
            string = "";
        }
        objectArray[0] = string;
        return (Component)Component.translatable((String)"linuxssh.command.error", (Object[])objectArray);
    }

    private static final void handleSshCommand$lambda$0(ServerPlayer $player, CommandSourceStack $source, String $command, Linuxssh this$0) {
        try {
            Session session;
            Session session2;
            ServerPlayer serverPlayer = $player;
            if (serverPlayer != null) {
                ServerPlayer it = serverPlayer;
                boolean bl = false;
                session2 = this$0.activeSessions.get(it.getUUID());
            } else {
                session2 = session = null;
            }
            if (session == null || !session.isConnected()) {
                $source.sendSuccess(Linuxssh::handleSshCommand$lambda$0$1, false);
                return;
            }
            Channel channel = session.openChannel("exec");
            Intrinsics.checkNotNull((Object)channel, (String)"null cannot be cast to non-null type com.jcraft.jsch.ChannelExec");
            ChannelExec channel2 = (ChannelExec)channel;
            channel2.setCommand($command);
            InputStream inputStream = channel2.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            channel2.connect();
            String line = null;
            while (true) {
                String string;
                String it = string = reader.readLine();
                boolean bl = false;
                line = it;
                if (string == null) break;
                String string2 = line;
                if (string2 == null) {
                    string2 = "";
                }
                String currentLine = string2;
                String formattedLine = this$0.formatAnsiToMinecraft(currentLine);
                $source.sendSuccess(() -> Linuxssh.handleSshCommand$lambda$0$3(formattedLine), false);
            }
            channel2.disconnect();
        }
        catch (Exception e) {
            $source.sendSuccess(() -> Linuxssh.handleSshCommand$lambda$0$4(e), false);
            e.printStackTrace();
        }
    }

    public static final /* synthetic */ Map access$getPendingFingerprints$p(Linuxssh $this) {
        return $this.pendingFingerprints;
    }
}

